#ifndef DX_VOS_PATHS_H
#define DX_VOS_PATHS_H

#include "DX_VOS_BaseTypes.h"

#ifdef __cplusplus
extern "C"
{
#endif

const DxChar* DX_VOS_RootPath(void);
const DxChar* DX_VOS_RomRootPath(void);
const DxChar* DX_VOS_PublicRootPath(void);
const DxChar* DX_VOS_DefaultRootDrive(void);

const DxChar* DX_VOS_PrefixRootPath(const DxChar* apPath);
const DxChar* DX_VOS_PrefixRomRootPath(const DxChar* apPath);
const DxChar* DX_VOS_PrefixPublicRootPath(const DxChar* apPath);
const DxChar* DX_VOS_PrefixDefaultRootDrive(const DxChar* apPath);

DxChar* DX_VOS_ExtendPrefixRootPath(const DxChar* apPostfix, DxChar* apOutputPath, DxUint32 aBuffSize);
DxChar* DX_VOS_ExtendPrefixRomRootPath(const DxChar* apPostfix, DxChar* apOutputPath, DxUint32 aBuffSize);
DxChar* DX_VOS_ExtendPrefixPublicRootPath(const DxChar* apPostfix, DxChar* apOutputPath, DxUint32 aBuffSize);
DxChar* DX_VOS_ExtendPrefixDefaultRootDrive(const DxChar* apPostfix, DxChar* apOutputPath, DxUint32 aBuffSize);

#ifdef __cplusplus
}
#endif

#endif

